@ECHO OFF
GOTO START
REM ************************************************************************************************
REM ************************************************************************************************
REM **
REM ** COPYRIGHT:    (c) 1998 Rohde & Schwarz, Munich
REM **
REM ** MODULE:       $Workfile: prepare.bat $
REM **
REM ** ABBREVIATION: PREPARE
REM **
REM ** LANGUAGE:     DOS - Batch
REM **
REM ** AUTHOR:       Thorsten Jakob, 1CM6
REM **
REM ** ABSTRACT:     prepares CMU with verm < 3.00 to install a new verm > 3.00.
REM **
REM ** Parameters:
REM **
REM ** 1.            %1 = source drive letter
REM **
REM ** 2.            %2 = source version (eg. 2V10 or 3X00.C04)
REM **
REM ** 3.            %3 = target prefix (BIN_)
REM **
REM ** 4.            %4 = kB free
REM **
REM **
REM **
REM **
REM ** HISTORY
REM ** $Log: prepare.bat $
REM
REM     /main/5.20/1    8 Dec 2008 17:04:25   schro_ra
REM
REM     /main/5.00/1   18 Feb 2008 12:45:39   schro_ra
REM
REM     /main/4.60/1    9 Nov 2007 18:38:30   schroe_r
REM
REM     /main/4.50/1    4 Jul 2007 12:32:03   schroe_r
REM
REM     /main/4.40/1   17 Jan 2007 12:55:50   schroe_r
REM
REM     /main/4.30/1   19 Dec 2006 13:53:13   schroe_r
REM
REM     /main/4.00/1    2 Sep 2005 09:46:22   SCHROE_R
REM
REM     /main/3.80/1    4 Apr 2005 13:11:17   schroe_r
rem  
rem     Rev 1.4.2.4   11 Sep 2002 11:04:30   THORSTEN
rem  Labels with .exe were not recognized by DOS
rem  showing also the path of the missing files
rem  
rem     Rev 1.4.2.3   16 May 2002 17:59:02   THORSTEN
rem  copy only selected files to c:\verm
rem  
rem     Rev 1.4.2.2   07 May 2002 11:57:58   thorsten
rem  redirect output of attrib
rem
rem     Rev 1.4.2.1   09 Apr 2002 16:34:54   thorsten
rem  adapted for Verm 3X10.A01
rem
rem     Rev 1.4.2.0   11 Jan 2002 13:20:56   thorsten
rem  prepare.bat for Verm >= 3.00!
rem  this prepare.bat is called only by Verm 2.XX,
rem  installs the new VERM reboot the CMU and the
rem  new Verm continues with the Installation
REM
REM     Rev 1.4   30 Mar 2000 12:04:34   MACKETAN
REM  attrib -R before call of archiv.exe
REM
REM     Rev 1.3   09 Mar 2000 12:06:32   MACKETAN
REM
REM
REM     Rev 1.2   17 Dec 1999 14:21:42   KIRCHHOF
REM  force the firmware update
REM
REM     Rev 1.1   09 Aug 1999 14:33:40   KIRCHHOF
REM  patch the bootsector
REM
REM     Rev 1.0   23 Dec 1998 15:47:44   KIRCHHOF
REM  initial revision
REM
REM **
REM ************************************************************************************************
REM ************************************************************************************************
:START
ECHO %0 %1 %2 %3 %4 >> c:\install.log
ECHO preparing system...
IF NOT EXIST C:\CMU\nul MD C:\CMU
IF NOT EXIST C:\CMU\UTILS\nul MD C:\CMU\UTILS

IF EXIST C:\CMU\%3%2\nul ATTRIB -R /S C:\CMU\%3%2\*.* >> c:\install.log
ATTRIB -R /S C:\CMU\UTILS\*.*  >> c:\install.log
ATTRIB -R    C:\*.*            >> c:\install.log

REM test if CMU software has been installed at least once
IF EXIST C:\CMU\DOS_SAVE.CNF\CONFIG.SYS GOTO NotFirstInst

REM create backup directory if not done yet
IF NOT EXIST C:\CMU\DOS_SAVE.CNF\nul MD C:\CMU\DOS_SAVE.CNF

ECHO Backup of configuration files >> c:\install.log
IF EXIST C:\CONFIG.SYS   COPY C:\CONFIG.SYS   C:\CMU\DOS_SAVE.CNF\.
IF EXIST C:\AUTOEXEC.BAT COPY C:\AUTOEXEC.BAT C:\CMU\DOS_SAVE.CNF\.
IF EXIST C:\AUTOCONF.BAT COPY C:\AUTOCONF.BAT C:\CMU\DOS_SAVE.CNF\.

REM save batch file to restore configuration
COPY %1\BASE%2\RECONF.BAT C:\CMU\UTILS\.
REM for extra fun make more than one
COPY %1\BASE%2\RECONF.BAT C:\CMU\DOS_SAVE.CNF\.


:NotFirstInst
REM create new version directory, if not done yet
IF NOT EXIST C:\CMU\%3%2\nul MD C:\CMU\%3%2
REM copy the 'CONFIG.INI' to the target
REM ECHO copying files ...
REM COPY %1\BASE%2\CONFIG.INI C:\CMU\%3%2\. >> c:\install.log
REM ECHO This version is not installed compleatly. It may not work. > C:\CMU\%3%2\INCOMPL.VER

IF EXIST %1\BASE%2\UNTGZ.EXE COPY %1\BASE%2\UNTGZ.EXE C:\CMU\UTILS\. >> c:\install.log

REM call selfextracting installation program
IF NOT EXIST %1\BASE%2\ARCHIV.EXE GOTO NoArchiv
%1\BASE%2\ARCHIV.EXE

REM test if archive is OK
IF NOT EXIST C:\CMU\UTILS\UNTGZ.EXE GOTO NoUntgz
UNTGZ.EXE -t C:\TEMP.TAR\ARCHIV.TGZ >> c:\install.log
IF ERRORLEVEL 1 GOTO NoVerChange

REM UNPACK VERM
ECHO extracting files ...
C:
CD C:\CMU\%3%2
UNTGZ.EXE -y C:\TEMP.TAR\ARCHIV.TGZ ../UTILS/*.* >> c:\install.log

REM test if installation failed
IF ERRORLEVEL 1 GOTO NoVerChange

ECHO installing new Verm ...
IF NOT EXIST C:\VERM\nul MD C:\VERM
copy C:\CMU\UTILS\VERM.EXE C:\VERM >> c:\install.log
copy C:\CMU\UTILS\VERM.BAT C:\VERM >> c:\install.log
copy C:\CMU\UTILS\BOOT.BAT C:\VERM >> c:\install.log
copy C:\CMU\UTILS\ENV.BAT C:\VERM >> c:\install.log

UNTGZ.EXE -y C:\TEMP.TAR\ARCHIV.TGZ CONFIG/*.* >> c:\install.log

REM test if installation failed
IF ERRORLEVEL 1 GOTO NoVerChange

copy C:\CMU\%3%2\CONFIG\AUTOEXEC.BAT C:\VERM >> c:\install.log
copy C:\CMU\%3%2\CONFIG\CONFIG.SYS C:\VERM >> c:\install.log

copy C:\VERM\AUTOEXEC.BAT C:\ >> c:\install.log
copy C:\VERM\CONFIG.SYS C:\ >> c:\install.log

echo please install following version: > c:\verm\verm.ini
echo s_drive_char = %1>> c:\verm\verm.ini
echo s_ver_name   = BASE%2>> c:\verm\verm.ini
echo t_ver_name   = %3%2>> c:\verm\verm.ini
echo kB_free      = %4>> c:\verm\verm.ini
echo upgrade      = 0>> c:\verm\verm.ini
echo this was selected by prepare.bat >> c:\verm\verm.ini

DELTREE /Y C:\TEMP.TAR >> c:\install.log

CLS
ECHO.
ECHO installation completed
ECHO.
ECHO.
ECHO.
ECHO.
ECHO.
ECHO.
ECHO.
ECHO.
ECHO.
ECHO.
rem PAUSE

IF EXIST C:\CMU\%3%2\INCOMPL.VER DEL C:\CMU\%3%2\INCOMPL.VER

IF EXIST C:\CMU\UTILS\SYNC.COM C:\CMU\UTILS\SYNC.COM
IF EXIST C:\CMU\UTILS\RESET.COM C:\CMU\UTILS\RESET.COM

rem Booting failed ?
GOTO End

:NoArchiv
ECHO %1\BASE%2\ARCHIV.EXE is missing.
ECHO.
GOTO NoVerChange

:NoUntgz
ECHO C:\CMU\UTILS\UNTGZ.EXE is missing.
ECHO.
DELTREE /Y C:\TEMP.TAR >> c:\install.log
GOTO NoVerChange

:NoVerChange
ECHO an error occurred during software installation.
ECHO Software version has not been changed.
ECHO.
PAUSE


:End


